<?php

namespace App\Filament\Resources\Imagegalleries\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class ImagegalleryForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('title')
                    ->label('Title')
                    ->maxLength(255)
                    ->nullable(),
                FileUpload::make('image')
                    ->label('Image')
                    ->disk('public')
                    ->directory('imagegalleries/images')
                    ->visibility('public')
                    ->image()
                    ->openable()
                    ->downloadable()
                    ->required(),
                FileUpload::make('thumbnail')
                    ->label('Thumbnail Image')
                    ->disk('public')
                    ->directory('imagegalleries/thumbnails')
                    ->visibility('public')
                    ->image()
                    ->openable()
                    ->downloadable()
                    ->nullable(),
                TextInput::make('thumbnail_url')
                    ->label('Thumbnail URL')
                    ->url()
                    ->maxLength(2048)
                    ->nullable(),
            ]);
    }
}
