<?php

namespace App\Filament\Resources\Imagegalleries;

use App\Filament\Resources\Imagegalleries\Pages\CreateImagegallery;
use App\Filament\Resources\Imagegalleries\Pages\EditImagegallery;
use App\Filament\Resources\Imagegalleries\Pages\ListImagegalleries;
use App\Filament\Resources\Imagegalleries\Pages\ViewImagegallery;
use App\Filament\Resources\Imagegalleries\Schemas\ImagegalleryForm;
use App\Filament\Resources\Imagegalleries\Schemas\ImagegalleryInfolist;
use App\Filament\Resources\Imagegalleries\Tables\ImagegalleriesTable;
use App\Models\Imagegallery;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;

class ImagegalleryResource extends Resource
{
    protected static ?string $model = Imagegallery::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedPhoto;

    protected static ?string $recordTitleAttribute = 'id';

    protected static ?string $navigationLabel = 'Image Gallery';

    protected static ?string $pluralModelName = 'Image Gallery';

    protected static function hasDashboardOption(): bool
    {
        $user = Auth::user();
        if ($user?->role === 'super_admin') {
            return true;
        }
        $options = $user?->dashboard_options ?? [];
        return in_array('image_gallery', $options, true);
    }

    public static function canViewAny(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canCreate(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canEdit($record): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canDelete($record): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function shouldRegisterNavigation(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function form(Schema $schema): Schema
    {
        return ImagegalleryForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ImagegalleryInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ImagegalleriesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListImagegalleries::route('/'),
            'create' => CreateImagegallery::route('/create'),
            'view' => ViewImagegallery::route('/{record}'),
            'edit' => EditImagegallery::route('/{record}/edit'),
        ];
    }
}
