<?php

namespace App\Filament\Resources\HomeVideos\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class HomeVideoForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('title')
                    ->required(),
                TextInput::make('subtitle')
                    ->default(null),
                Textarea::make('description')
                    ->default(null)
                    ->columnSpanFull(),
                TextInput::make('button_name')
                    ->default(null),
                FileUpload::make('video')
                    ->acceptedFileTypes(['video/mp4', 'video/mpeg', 'video/quicktime', 'video/webm'])
                    ->maxSize(102400)
                    ->disk('public')
                    ->directory('videos')
                    ->helperText('Upload a video (max 50 seconds, max 100MB)')
                    ->columnSpanFull(),
                FileUpload::make('image')
                    ->acceptedFileTypes(['image/jpeg', 'image/png', 'image/jpg', 'image/gif', 'image/webp'])
                    ->maxSize(10240)
                    ->disk('public')
                    ->directory('images/hero')
                    ->helperText('Upload an image (max 10MB). When active, this will replace the video.')
                    ->columnSpanFull(),
                Toggle::make('is_image_active')
                    ->label('Enable Image (Disable Video)')
                    ->helperText('Toggle ON to show image instead of video in hero section')
                    ->default(false),
            ]);
    }
}
