<?php

namespace App\Filament\Resources\Footers;

use App\Filament\Resources\Footers\Pages\CreateFooter;
use App\Filament\Resources\Footers\Pages\EditFooter;
use App\Filament\Resources\Footers\Pages\ListFooters;
use App\Filament\Resources\Footers\Pages\ViewFooter;
use App\Models\Footer;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;

use Filament\Schemas\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;

use Filament\Tables\Columns\TextColumn;

use Filament\Actions\EditAction;

class FooterResource extends Resource
{
    protected static ?string $model = Footer::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedCog6Tooth;

    protected static ?string $recordTitleAttribute = 'email';

     protected static ?string $navigationLabel = 'Footer';

    protected static ?int $navigationSort = 50;

    protected static function hasDashboardOption(): bool
    {
        $user = Auth::user();
        if ($user?->role === 'super_admin') {
            return true;
        }
        $options = $user?->dashboard_options ?? [];
        return in_array('footers', $options, true); // change to your option key if needed
    }

    public static function canViewAny(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canCreate(): bool
    {
        if (! (Auth::check() && static::hasDashboardOption())) {
            return false;
        }

        return Footer::query()->count() === 0;
    }

    public static function canEdit($record): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canDelete($record): bool
    {
        return false;
    }

    public static function shouldRegisterNavigation(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function form(Schema $schema): Schema
    {
        return $schema->components([
      

            Section::make('Social Links')
                ->schema([
                    TextInput::make('facebook_url')->label('Facebook URL')->url()->nullable(),
                    TextInput::make('youtube_url')->label('YouTube URL')->url()->nullable(),
                    TextInput::make('instagram_url')->label('Instagram URL')->url()->nullable(),
                    TextInput::make('twitter_url')->label('Twitter / X URL')->url()->nullable(),
                    TextInput::make('tiktok_url')->label('TikTok URL')->url()->nullable(),
                    TextInput::make('whatsapp_url')->label('WhatsApp URL')->url()->nullable(),
                    TextInput::make('linkedin_url')->label('LinkedIn URL')->url()->nullable(),
                    TextInput::make('telegram_url')->label('Telegram URL')->url()->nullable(),
                ])
                ->columns(2),

            Section::make('Contact (Optional)')
                ->schema([
                    TextInput::make('email')->email()->nullable(),
                    TextInput::make('phone')->tel()->nullable(),
                    TextInput::make('address')->nullable(),
                ])
                ->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')->sortable(),

                TextColumn::make('email')
                    ->label('Email')
                    ->searchable()
                    ->sortable(),

                TextColumn::make('phone')
                    ->label('Phone')
                    ->limit(40),

                TextColumn::make('updated_at')
                    ->label('Updated')
                    ->dateTime()
                    ->sortable(),
            ])
            ->actions([
                EditAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListFooters::route('/'),
            'create' => CreateFooter::route('/create'),
            'edit'   => EditFooter::route('/{record}/edit'),
        ];
    }
}
