<?php

namespace App\Filament\Resources\Contacts;

use App\Filament\Resources\Contacts\Pages\CreateContact;
use App\Filament\Resources\Contacts\Pages\EditContact;
use App\Filament\Resources\Contacts\Pages\ListContacts;
use App\Filament\Resources\Contacts\Pages\ViewContact;
use App\Filament\Resources\Contacts\Schemas\ContactForm;
use App\Filament\Resources\Contacts\Schemas\ContactInfolist;
use App\Filament\Resources\Contacts\Tables\ContactsTable;
use App\Models\Contact;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;

use Filament\Tables\Columns\TextColumn;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\ViewAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
class ContactResource extends Resource
{
    protected static ?string $model = Contact::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedEnvelope;

    protected static ?string $recordTitleAttribute = 'Contact';

    protected static ?string $navigationLabel = 'Contact Messages';

    protected static ?string $pluralModelName = 'Contact Messages';

    protected static function hasDashboardOption(): bool
    {
        $user = Auth::user();
        if ($user?->role === 'super_admin') {
            return true;
        }
        $options = $user?->dashboard_options ?? [];
        return in_array('contacts', $options, true);
    }

    public static function canViewAny(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canCreate(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canEdit($record): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function canDelete($record): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function shouldRegisterNavigation(): bool
    {
        return Auth::check() && static::hasDashboardOption();
    }

    public static function form(Schema $schema): Schema
    {
        return $schema->components([

    TextInput::make('firstname')
        ->label('First Name')
        ->minLength(2)
        ->maxLength(255)
        ->required(),

    TextInput::make('lastname')
        ->label('Last Name')
        ->minLength(2)
        ->maxLength(255)
        ->required(),

    TextInput::make('email')
        ->label('Email')
        ->email()
        ->maxLength(255)
        ->required(),

    TextInput::make('phone_number')
        ->label('Phone Number')
        ->tel()
        ->maxLength(20)
        ->required(),

    Textarea::make('message')
        ->label('Message')
        ->rows(4)
        ->maxLength(1000)
        ->required(),
]);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ContactInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
    return $table
    ->columns([
        TextColumn::make('firstname')
            ->label('First Name')
            ->searchable(),

        TextColumn::make('lastname')
            ->label('Last Name')
            ->searchable(),

        TextColumn::make('email')
            ->label('Email')
            ->searchable(),

        TextColumn::make('phone_number')
            ->label('Phone')
            ->searchable(),

        TextColumn::make('message')
            ->label('Message')
            ->limit(40),

        TextColumn::make('created_at')
            ->label('Created At')
            ->dateTime()
            ->sortable(),
    ])
    ->filters([
        //
    ])
    ->actions([
        ViewAction::make(),
        EditAction::make(),
        DeleteAction::make(),
    ])
    ->bulkActions([
        BulkActionGroup::make([
            DeleteBulkAction::make(),
        ]),
    ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListContacts::route('/'),
            'view' => ViewContact::route('/{record}'),
        ];
    }
}
