<?php

namespace App\Filament\Resources\Blogs\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\TagsColumn;
use Filament\Tables\Table;

class BlogsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                ImageColumn::make('image_url')
                    ->label('Image'),

                TextColumn::make('date')
                    ->label('Date')
                    ->date('d/m/Y')
                    ->sortable(),

                TextColumn::make('title')
                    ->label('Title')
                    ->searchable(),

                TextColumn::make('description_html')
                    ->label('Description')
                    ->limit(50)
                    ->wrap(),

                TagsColumn::make('tags')
                    ->label('Tags'),

                // ✅ Social Links
                TextColumn::make('facebook_url')
                    ->label('Facebook')
                    ->url(fn ($record) => $record->facebook_url, true)
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('youtube_url')
                    ->label('YouTube')
                    ->url(fn ($record) => $record->youtube_url, true)
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('instagram_url')
                    ->label('Instagram')
                    ->url(fn ($record) => $record->instagram_url, true)
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('twitter_url')
                    ->label('Twitter (X)')
                    ->url(fn ($record) => $record->twitter_url, true)
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
