<?php

namespace App\Filament\Resources\Blogs\Schemas;

use App\Rules\MaxWords;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TagsInput;
use Filament\Schemas\Schema;

use Filament\Forms\Components\RichEditor;


class BlogForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([

                // Image upload
                FileUpload::make('image')
                    ->disk('public')
                    ->directory('blogs')
                    ->image()
                    ->maxSize(6144),

                // Blog date
                DatePicker::make('date')
                    ->format('d/m/Y')
                    ->required(),

                // Blog title
                TextInput::make('title')
                    ->required()
                    ->maxLength(255),

                // Blog description
           RichEditor::make('description')
    ->label('Description')
    ->columnSpanFull()
    ->json()
                    ->fileAttachmentsDisk('public')
                    ->fileAttachmentsDirectory('blogs/attachments')
                    ->fileAttachmentsVisibility('public')
    ->helperText('Maximum 800 words.')
    ->extraAttributes([
        'style' => 'min-height: 350px; resize: vertical;',
    ])
    ->toolbarButtons([
        'bold',
        'italic',
        'underline',
        'strike',
        'link',
        'h2',
        'h3',
        'blockquote',
        'codeBlock',
        'bulletList',
        'orderedList',
        'attachFiles',
        'undo',
        'redo',
    ]),

                // Tags
                TagsInput::make('tags')
                    ->separator(',')
                    ->helperText('Press Enter after each tag'),

                // Social Media URLs
                TextInput::make('facebook_url')
                    ->label('Facebook URL')
                    ->url()
                    ->nullable(),

                TextInput::make('youtube_url')
                    ->label('YouTube URL')
                    ->url()
                    ->nullable(),

                TextInput::make('instagram_url')
                    ->label('Instagram URL')
                    ->url()
                    ->nullable(),

                TextInput::make('twitter_url')
                    ->label('Twitter (X) URL')
                    ->url()
                    ->nullable(),
            ]);
    }
}
